/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced;

import com.barion.dungeons_enhanced.DEConfig;
import com.barion.dungeons_enhanced.structures.DEBattleTower;
import com.barion.dungeons_enhanced.structures.DECastle;
import com.barion.dungeons_enhanced.structures.DEDesertTemple;
import com.barion.dungeons_enhanced.structures.DEDesertTomb;
import com.barion.dungeons_enhanced.structures.DEDruidCircle;
import com.barion.dungeons_enhanced.structures.DEDungeonVariant;
import com.barion.dungeons_enhanced.structures.DEHayStorage;
import com.barion.dungeons_enhanced.structures.DEIcePit;
import com.barion.dungeons_enhanced.structures.DEJungleMonument;
import com.barion.dungeons_enhanced.structures.DELargeDungeon;
import com.barion.dungeons_enhanced.structures.DEMinersHouse;
import com.barion.dungeons_enhanced.structures.DEMobTower;
import com.barion.dungeons_enhanced.structures.DEMushroomHouse;
import com.barion.dungeons_enhanced.structures.DEPillagerCamp;
import com.barion.dungeons_enhanced.structures.DERuinedBarn;
import com.barion.dungeons_enhanced.structures.DERuinedHouse;
import com.barion.dungeons_enhanced.structures.DEStables;
import com.barion.dungeons_enhanced.structures.DETallWitchHut;
import com.barion.dungeons_enhanced.structures.DETreeHouse;
import com.barion.dungeons_enhanced.structures.DEWatchTower;
import com.barion.dungeons_enhanced.structures.DEWitchTower;
import com.barion.dungeons_enhanced.structures.prefabs.DECellar;
import com.barion.dungeons_enhanced.structures.prefabs.DECellarStructure;
import com.barion.dungeons_enhanced.structures.prefabs.DESimpleStructure;
import com.barion.dungeons_enhanced.structures.prefabs.DEUndergroundStructure;
import com.legacy.structure_gel.access_helpers.JigsawAccessHelper;
import com.legacy.structure_gel.registrars.GelStructureRegistrar;
import com.legacy.structure_gel.registrars.StructureRegistrar2;
import com.legacy.structure_gel.worldgen.structure.GelConfigStructure;
import com.legacy.structure_gel.worldgen.structure.GelStructure;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="dungeons_enhanced", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DEStructures {
    public static final StructureRegistrar2<NoFeatureConfig, DEBattleTower> BattleTower = DEStructures.register("battle_tower", new DEBattleTower(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DECastle> Castle = DEStructures.register("castle", new DECastle(), DECellarStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DECellar> CastleB = GelStructureRegistrar.of((ResourceLocation)new ResourceLocation(""), (GelStructure)new DECellar("castle/bottom", DEStructures.Offset(0, -5, 0), Castle, DEConfig.COMMON.castle), DECellar.Piece::new, (IFeatureConfig)NoFeatureConfig.field_236559_b_, (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();
    public static final StructureRegistrar2<NoFeatureConfig, DEDesertTemple> DesertTemple = DEStructures.register("desert_temple", new DEDesertTemple(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DEDesertTomb> DesertTomb = DEStructures.register("desert_tomb", new DEDesertTomb(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DEDruidCircle> DruidCircle = DEStructures.register("druid_circle", new DEDruidCircle(), DECellarStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DEDungeonVariant> DungeonVariant = DEStructures.register("dungeon_variant", new DEDungeonVariant(), DEUndergroundStructure.Piece::new, GenerationStage.Decoration.UNDERGROUND_STRUCTURES);
    public static final StructureRegistrar2<NoFeatureConfig, DEHayStorage> HayStorage = DEStructures.register("hay_storage", new DEHayStorage(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DEIcePit> IcePit = DEStructures.register("ice_pit", new DEIcePit(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DEJungleMonument> JungleMonument = DEStructures.register("jungle_monument", new DEJungleMonument(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DELargeDungeon> LargeDungeon = GelStructureRegistrar.of((ResourceLocation)DEStructures.locate("large_dungeon"), (GelStructure)new DELargeDungeon(), DESimpleStructure.Piece::new, (IFeatureConfig)NoFeatureConfig.field_236559_b_, (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureRegistrar2<NoFeatureConfig, DEMinersHouse> MinersHouse = DEStructures.register("miners_house", new DEMinersHouse(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DEMobTower> MobTower = DEStructures.register("mob_tower", new DEMobTower(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DEMushroomHouse> MushroomHouse = DEStructures.register("mushroom_house", new DEMushroomHouse(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DEPillagerCamp> PillagerCamp = DEStructures.register("pillager_camp", new DEPillagerCamp(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DERuinedBarn> RuinedBarn = DEStructures.register("ruined_barn", new DERuinedBarn(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DERuinedHouse> RuinedHouse = DEStructures.register("ruined_house", new DERuinedHouse(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DEStables> Stables = DEStructures.register("stables", new DEStables(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DETallWitchHut> TallWitchHut = DEStructures.register("tall_witch_hut", new DETallWitchHut(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DETreeHouse> TreeHouse = DEStructures.register("tree_house", new DETreeHouse(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DEWatchTower> WatchTower = DEStructures.register("watch_tower", new DEWatchTower(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar2<NoFeatureConfig, DEWitchTower> WitchTower = DEStructures.register("witch_tower", new DEWitchTower(), DESimpleStructure.Piece::new);

    @SubscribeEvent
    public static void onRegistry(RegistryEvent.Register<Structure<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        BattleTower.handleForge(registry);
        Castle.handleForge(registry);
        CastleB.handleForge(registry);
        RuinedHouse.handleForge(registry);
        RuinedBarn.handleForge(registry);
        DesertTemple.handleForge(registry);
        DesertTomb.handleForge(registry);
        DruidCircle.handleForge(registry);
        HayStorage.handleForge(registry);
        IcePit.handleForge(registry);
        JungleMonument.handleForge(registry);
        LargeDungeon.handleForge(registry);
        DungeonVariant.handleForge(registry);
        MinersHouse.handleForge(registry);
        MobTower.handleForge(registry);
        MushroomHouse.handleForge(registry);
        PillagerCamp.handleForge(registry);
        Stables.handleForge(registry);
        TallWitchHut.handleForge(registry);
        TreeHouse.handleForge(registry);
        WatchTower.handleForge(registry);
        WitchTower.handleForge(registry);
        DEStructures.genFloor(RuinedHouse, RuinedBarn, DruidCircle, BattleTower, HayStorage, DruidCircle, MinersHouse, MobTower, MushroomHouse, WatchTower, WitchTower, Castle, PillagerCamp, TreeHouse);
    }

    private static <S extends GelConfigStructure<NoFeatureConfig>> StructureRegistrar2<NoFeatureConfig, S> register(String locate, S structure, IStructurePieceType piece) {
        return GelStructureRegistrar.of((ResourceLocation)DEStructures.locate(locate), structure, (IStructurePieceType)piece, (IFeatureConfig)NoFeatureConfig.field_236559_b_, (GenerationStage.Decoration)GenerationStage.Decoration.SURFACE_STRUCTURES).handle();
    }

    private static <S extends GelConfigStructure<NoFeatureConfig>> StructureRegistrar2<NoFeatureConfig, S> register(String locate, S structure, IStructurePieceType piece, GenerationStage.Decoration decoration) {
        return GelStructureRegistrar.of((ResourceLocation)DEStructures.locate(locate), structure, (IStructurePieceType)piece, (IFeatureConfig)NoFeatureConfig.field_236559_b_, (GenerationStage.Decoration)decoration).handle();
    }

    public static ResourceLocation locate(String key) {
        return new ResourceLocation("dungeons_enhanced", key);
    }

    private static void genFloor(StructureRegistrar2 ... structureRegs) {
        for (StructureRegistrar2 structure : structureRegs) {
            JigsawAccessHelper.addIllagerStructures((Structure[])new Structure[]{structure.getStructure()});
        }
    }

    private static BlockPos Offset(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }
}

